<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\SurviesController;
use App\Http\Controllers\UserController;
use App\Models\Customer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;


Route::group(
    [
        'middleware' => 'api',
        'prefix' => 'admin'
    ], function() {
        Route::post("/login", [AdminController::class, 'login'])->name('login');
        Route::post("/make_admin_user", [AdminController::class, 'createAdminUser']);
        Route::post('/me', [AdminController::class, 'me']);
        Route::post("/make_account", [AdminController::class, "crateAccount"]);
        Route::get("/list_accounts", [AdminController::class, "listAccounts"]);
        Route::post("/change_account_status", [AdminController::class, "changeStatusAccount"]);
        Route::post("/create_gas_station", [AdminController::class, "newGasStation"]);
        Route::post("/create_question", [AdminController::class, "newQuestion"]);
        Route::get("/list_questions", [AdminController::class, "listQuestions"]);
        Route::post("/new_user", [AdminController::class, "newUser"]);
        Route::get("/categories", [AdminController::class, "listCategories"]);
        Route::post("/categories", [AdminController::class, "newCategory"]);
        Route::get("/list_users", [AdminController::class, "listUsers"]);
        Route::get("/list_gas_station/{station}", [AdminController::class, "listGasStation"]);

    });
Route::group(
    [
        'middleware' => 'api',
        'prefix' => 'user'
    ], function() {
        Route::post("/login", [UserController::class, 'login']);
        Route::get("/dashboard", [UserController::class, 'dashboard']);
        Route::get("/list_stations", [UserController::class, 'listStations']);
        Route::post("/station/edit", [UserController::class, 'editStation']);
        Route::post("/station/save", [UserController::class, 'newStation']);

        Route::get("/survies", [UserController::class, 'listSurvies']);
        Route::get("/survey/{survey}", [UserController::class, 'surveyData']);
        Route::post("survey/new", [UserController::class, 'newSurvey']);
        Route::get("questions/{survey}", [UserController::class, 'listQuestions']);
        Route::get("questions/{survey}/respuestas/{question}", [UserController::class, 'showAnswersOptions']);
        Route::post("questions/{survey}/save", [UserController::class, 'newQuestion']);
        Route::post("questions/{survey}/option/save", [UserController::class, 'newOption']);

        Route::get("users", [UserController::class, 'listUsers']);
        Route::post("users/new", [UserCOntroller::class, 'newUser']);
        Route::post("users/edit", [UserCOntroller::class, 'editUser']);
        Route::post("users/delete", [UserCOntroller::class, 'deleteUser']);
    }
);

Route::group(
    [
        'middleware' => 'api',
        'prefix' => 'user/customer'
    ],
    function () {
        Route::post("/auth", [CustomerController::class, 'auth']);
        Route::get("/home/{token}", [CustomerController::class, 'home']);
    });

    Route::get("/test", [AdminController::class, "crateAccount"]);
