<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('satis_survies_questions', function (Blueprint $table) {
            $table->id();
            $table->integer('question_id')->nullable(false)->index('SQ_QUESTION_ID_INDEX');
            $table->integer("survey_id")->nullable(false)->index('SQ_SURVEY_ID_INDEX');
            $table->tinyInteger('is_active')->index('SQ_ACTIVE_INDEX');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('satis_survies_questions');
    }
};
