<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('satis_questions', function (Blueprint $table) {
            $table->id();
            $table->string('question');
            $table->tinyInteger('question_type');
            $table->tinyInteger('answer_type');
            $table->bigInteger('category_id');
            $table->tinyInteger('can_edit');
            $table->tinyInteger('is_active')->default(1);
            $table->dateTime('created_at');
            $table->dateTime('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('satis_questions');
    }
};
