<?php  
namespace App\Models\Entities;

enum ActiveStatus: int
{
    case Disabled = 0;
    case Active = 1;

    public function label(): string
    {
        return match($this) {
            static::Disabled => 'Deshabilitada',
            static::Active => 'Activa',
        };
    }

    public function action(): string
    {
        return match($this) {
            static::Disabled => 'desactivar',
            static::Active => 'activar',
        };
    }
}