<?php

namespace App\Http\Controllers;

use App\Admin\Question\QuestionGetter;
use App\Admin\Survey\SurveyService;
use App\Business\UserProfile\Locations\LocationsGetter;
use App\Business\UserProfile\Questions\QuestionServic;
use App\Business\UserProfile\Questions\QuestionService;
use App\Business\UserProfile\Questions\QuestionsGetter;
use App\Business\UserProfile\Stations\StationsGetter;
use App\Business\UserProfile\Stations\StationsService;
use App\Business\UserProfile\Survies\SurviesGetter;
use App\Business\UserProfile\Users\UserService;
use App\Exceptions\BadPasswordException;
use App\Http\Response\ResponseApi;
use Error;
use Exception;
use GuzzleHttp\Psr7\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Exception\BadRequestException;

class UserController extends Controller
{
    public static function middleware(): array
    {
        return [
            new Middleware(middleware: 'auth:web', except: ['login', 'createAdminUser']),
        ];
    }
    public function __construct()
    {
    }

    public function login(Request $request)
    {
        try {
            $auth = new UserService();
            $token = $auth->makeLogin($request);
            $response = [
                "data" => $token,
                "message" => ''
            ];
            return response()->json($response);
        } catch (BadPasswordException $e) {
            return response()->json(['error' => $e->getMessage()], 401);
        }    
    }

    public function listStations(){
        try {
            $stations = StationsService::listUserStations();
            return ResponseApi::Ok($stations);
        } catch (Exception $e) {
            return ResponseApi::Error();
        }
    }

    public function dashboard(){
        try {
            $user = Auth::user();
            $survies = SurviesGetter::getSuriviesByAccount($user->account_id);
            if($user->user_type == 1){
                $stations = StationsGetter::getStationsByAccount($user->account_id);
            }else{
                $stations = StationsGetter::getStationsByUser($user->id);
            }
            
            $locations = LocationsGetter::getLocations();
            return ResponseApi::Ok(['stations' => $stations, 'survies' => $survies, 'locations' => $locations ]);
        } catch (Exception $e) {
            return ResponseApi::Error();
        }
    }

    public function editStation(Request $request){
        try {
            $station = StationsService::editStation(
                $request->id,
                trim($request->name),
                $request->state,
                $request->municipality,
                $request->survey
            );

            return ResponseApi::Ok($station);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function newStation(Request $request)
    {
        try {
            $station = StationsService::saveStation(
                trim($request->pl),
                trim($request->cre_id),
                trim($request->name),
                $request->state,
                $request->municipality,
                $request->survey
            );

            return ResponseApi::Ok($station);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function listSurvies(){
        try {
            $user = Auth::user();
            $survies = SurviesGetter::getSuriviesDetailByAccount($user->account_id);
            return  ResponseApi::Ok($survies);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function newSurvey(Request $request){
        try {
            $user = Auth::user();
            $survey = SurveyService::createDefualtSurvey($user->id,$user->account_id,trim($request->name));
            return ResponseApi::Ok($survey);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function listQuestions($survey){
        try {
            $questions = QuestionsGetter::getQuestionsBySurvey($survey);
            return ResponseApi::Ok($questions);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function surveyData($survey){
        $survey = SurviesGetter::getSurveyBasicInfoById($survey);
        return $survey;
    }

    public function showAnswersOptions($survey, $question){
        try {
            $surveyData = QuestionsGetter::getQuestionById($question);
            $options = QuestionsGetter::getAnwesOptionsByQuestion($question);
            return ResponseApi::Ok(['options' => $options, 'question' => $surveyData]);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function newQuestion($survey, Request $request){
        try {
            $question = QuestionService::createQuestion(
                trim($request->question),
                $request->answer_type,
                $survey
            );
            return ResponseApi::Ok($question);
        } catch (Exception $e) {
            return ResponseApi::Error(500,$e->getMessage());
        }
        
    }

    public function newOption(Request $request){
        try {
            $options = QuestionService::addOptions($request->question, $request->option_type ,$request->options);
            return ResponseApi::Ok($options);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function listUsers(){
        try {
            $users = UserService::listUserByAccount();
            return ResponseApi::Ok($users);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function newUser(Request $request){
        try {
            $user = UserService::createUser(
                trim($request->user_name),
                $request->key,
                trim($request->name),
                trim($request->email),
                trim($request->phone),
                $request->is_manager,
                $request->has_admin,
                $request->has_movil,
                $request->has_web,
            );
            return ResponseApi::Ok($user);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function editUser(Request $request)
    {
        try {
            $user = UserService::editUser(
                $request->id,
                trim($request->user_name),
                trim($request->name),
                trim($request->email),
                trim($request->phone),
                $request->is_manager,
                $request->has_admin,
                $request->has_web,
                $request->has_movil,
            );
            return ResponseApi::Ok($user);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function deleteUser(Request $request){
        try {
            UserService::deleteUser($request->id);
            return ResponseApi::Ok();
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

}
