<?php

namespace App\Http\Controllers;

use App\Business\CustomerProfile\Customer\CustomerService;
use App\Http\Response\ResponseApi;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Routing\Controllers\Middleware;
use Illuminate\Support\Facades\Auth;

class CustomerController extends Controller
{
    public static function middleware(): array
    {
        return [
            new Middleware(middleware: 'auth:customer', except: ['auth']),
        ];
    }
    public function __construct() {}

    public function auth(Request $request){
        return CustomerService::makeLogin($request);
    }

    public function home(Request $request, $token)
    {
        // try {
            $data = CustomerService::getAllData($token);
            
            return ResponseApi::Ok($data);
        // } catch (Exception $e) {
        //     return ResponseApi::Error(500, $e->getMessage());
        // }
    }
}
