<?php

namespace App\Http\Controllers;

use App\Admin\Account\AccountGetter;
use App\Admin\Account\AccountService;
use App\Admin\Category\CategoryGetter;
use App\Admin\Category\CategoryService;
use App\Admin\GasStation\GasStationGetter;
use App\Admin\Question\QuestionGetter;
use App\Admin\Question\QuestionService;
use App\Admin\UserAdmin\UserAdminService;
use App\Admin\Users\UsersGetter;
use App\Admin\Users\UsersServices;
use App\Exceptions\BadPasswordException;
use App\Http\Response\ResponseApi;
use App\Models\Admin\AdminUser;
use Illuminate\Http\Request;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;
use Symfony\Component\HttpFoundation\Exception\BadRequestException;
use App\Models\Entities\AccountType;
use Exception;

class AdminController extends Controller implements HasMiddleware
{

    public static function middleware(): array
    {
        return [
            new Middleware(middleware: 'auth:admin', except: ['login','createAdminUser']),
        ];
    }
    public function __construct()
    {
    }

    public function login(Request $request)
    {
        try {
        $auth = new UserAdminService();
        $token = $auth->makeLogin($request);
        $response = [
            "data" => $token,
            "message" =>''
        ];
        return response()->json($response);
        } catch (BadRequestException $e) {
            return response()->json(['error' => $e->getMessage()], 401);
        }    
    }

    public function createAdminUser(Request $request){
        try {
            $obj = new UserAdminService();
            $obj->newUser($request);
            return response()->json(["data" => null, "message" => "registro creado satisfactoriamente"], 200);
        } catch (BadPasswordException $e) {
            return response()->json(["data" => null, "message" => $e->getMessage()], 500);
        }
    }

    public function crateAccount(Request $request){
        try {
            $account = AccountService::createAcount($request);
            // return $account; exit;
            return response()->json(["data" => $account, "message" => "cuenta creada satisfactoriamente"], 200);
        } catch (Exception $e) {
            return response()->json(["data" => null, "message" => $e->getMessage()], 500);
        }
    }

    public function listAccounts(){
        try {
            $accounts = AccountGetter::getListAccounts();
            return ResponseApi::Ok($accounts);
        } catch (Exception $e) {
            return ResponseApi::Error(500,$e->getMessage());
        }
    }

    public function changeStatusAccount(Request $request){
        try {
            AccountService::disableEnableAccount($request->account, $request->status);
            return ResponseApi::Ok();
        } catch (Exception $e) {
            return ResponseApi::Error(500,$e->getMessage());
        }
    }

    public function changeAccountType(){
        try {
            AccountService::disableEnableAccount($request->account, $request->$status);
            return ResponseApi::Ok();
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function newGasStation(Request $request){
        try {
            $station = AccountService::createStation(
                $request->account,
                $request->name,
                $request->pl,
                $request->manager,
                $request->phone
            );
            return ResponseApi::Ok($station);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function listGasStation($account){
        $stations = GasStationGetter::getStationsByAccount($account);
        return ResponseApi::Ok($stations);
    }

    public function newQuestion(Request $request){
        try {
            $question = QuestionService::createQuestion(
                $request->question,
                $request->answer_type,
                $request->category,
                $request->options
            );
            return ResponseApi::Ok($question);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function listQuestions(){
        $questions = QuestionGetter::getDefaultQuestions();
        return ResponseApi::Ok($questions);
    }

    public function me()
    {
        return UserAdminService::test();
    }

    public function newUser(Request $request){
        try {
            $user = UsersServices::createUser(
                $request->name,
                $request->email,
                $request->account
            );
            return ResponseApi::Ok($user);
        } catch (Exception $e) {
            return ResponseApi::Error(500,$e->getMessage());
        }
    }

    public function listUsers(){
        try {
            $users = UsersGetter::getActiveUsers();
            return ResponseApi::Ok($users);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function newCategory(Request $request){
        try {
            $category = CategoryService::createCategory(
                $request->name,
                $request->description
            );
            return ResponseApi::Ok($category);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }

    public function listCategories(){
        try {
            $categories = CategoryGetter::getCategories();
            return ResponseApi::Ok($categories);
        } catch (Exception $e) {
            return ResponseApi::Error(500, $e->getMessage());
        }
    }
}
