<?php  

namespace App\Business\UserProfile\Users;

use App\Models\User;
use Illuminate\Support\Facades\DB;

class UserGetter
{
    public static function getUserByEmail($email){
        $user = User::where('email', $email)->first();
        return $user;
    }

    public static function findUser($user){
        $user = User::find($user);
        return $user;
    }

    public static function getUserById($user)
    {
        $users = DB::table('satis_users as su')
        ->join('satis_permissions_users as spu', 'spu.user_id', '=', 'su.id')
        ->join('satis_permissions as sp', 'sp.id', '=', 'spu.permission_id')
        ->select(
            'su.id',
            'su.user',
            'su.account_id',
            'su.email',
            'su.is_active',
            'su.user_type',
            'sp.type',
            'sp.id as permission'
        )
            ->where('su.id', $user)
            ->get();

        $groupedResults = $users->groupBy('id')->map(function ($userPermissions) {
            $user = $userPermissions->first();

            return [
                'id' => $user->id,
                'user' => $user->user,
                'account_id' => $user->account_id,
                'email' => $user->email,
                'is_active' => $user->is_active,
                'user_type' => $user->user_type,
                'permissions' => $userPermissions->pluck('permission')->all(),
            ];
        })->values();
        return $groupedResults;
    }

    public static function getAllUsersByAccount($account){
        $users = DB::table('satis_users as su')
            ->leftJoin('satis_permissions_users as spu', 'spu.user_id', '=', 'su.id')
            ->leftJoin('satis_permissions as sp', 'sp.id', '=', 'spu.permission_id')
            ->select(
                'su.id',
                'su.user',
                'su.account_id',
                'su.email',
                'su.is_active',
                'su.user_type',
                'sp.type',
                'sp.id as permission',
                'su.name',
                'su.phone'
            )
            ->where('su.account_id', '=', $account)
            ->where('su.is_active','=', true)
            ->get();

        $groupedResults = $users->groupBy('id')->map(function ($userPermissions) {
            $user = $userPermissions->first();

            return [
                'id' => $user->id,
                'user' => $user->user,
                'account_id' => $user->account_id,
                'email' => $user->email,
                'is_active' => $user->is_active,
                'user_type' => $user->user_type,
                'name' => $user->name,
                'phone' => $user->phone,
                'permissions' => $userPermissions->pluck('permission')->all(),
                // 'permissions' => $userPermissions->map(function ($permission) {
                //     return [
                //         'type' => $permission->type,
                //         'id' => $permission->id,
                //     ];
                // })->values()
            ];
        })->values(); 
        return $groupedResults;
    }
}
