<?php  

namespace App\Business\UserProfile\Survies;

use App\Models\Survey;
use Illuminate\Support\Facades\DB;

class SurviesGetter
{
    public static function getSuriviesByAccount($account){
        $survies = Survey::where('account_id', $account)->get();
        return $survies;
    }

    public static function getSuriviesDetailByAccount($account)
    {
        $survies = DB::table('satis_survies as ss')
        ->join('satis_survies_questions as ssq', 'ssq.survey_id', '=', 'ss.id')
        ->join('satis_questions as sq', 'sq.id', '=', 'ssq.question_id')
        ->leftJoin('satis_gas_stations as sgs', 'sgs.survey_id', '=', 'ss.id')
        ->select('ss.id as survey', 'ss.name')
        ->selectRaw('COUNT(CASE WHEN sq.question_type = 0 THEN 1 END) AS required')
        ->selectRaw('COUNT(CASE WHEN sq.question_type = 1 THEN 1 END) AS optional')
        ->selectRaw('COUNT(DISTINCT sgs.id) AS total_gas_stations')
        ->where('ss.account_id', $account)
        ->groupBy('ss.id', 'ss.name')
        ->orderBy('ss.id')
        ->get();
        return $survies;
    }

    public static function getSurveyBasicInfoById($surveyId){
        $survey = Survey::where('id', $surveyId)->first();
        return $survey;
    }
}
