<?php  

namespace App\Business\UserProfile\Stations;

use App\Models\GasStation;
use Exception;
use Illuminate\Support\Facades\Auth;

class StationsService
{
    public static function listUserStations(){
        $user = Auth::user()->id;
        $stations = StationsGetter::getStationsByUser($user);
        return $stations;
    }

    public static function editStation($st, $name, $state, $municipality, $survey){
       try {
            $station = StationsGetter::findSatation($st);
            $station->name = $station->name != $name ? $name : $station->name;
            $station->state_id = $station->state_id != $state ? $state : $station->state_id;
            $station->municipality_id = $station->municipality_id != $municipality ? $municipality : $station->municipality_id;
            $station->survey_id = $station->survey_id != $survey ? $survey : $station->survey_id ;

            $station->save();
            return $station;
       } catch (Exception $e) {
        throw new Exception($e->getMessage(), 1);
        
       }
    }

    public static function saveStation($pl, $creId, $name, $state, $municipality, $survey)
    {
        try {
            $account = Auth::user()->account_id;
            $station = GasStation::create([
                'account_id' => $account,
                'survey_id' => $survey,
                'pl' => $pl,
                'cre_id' => $creId ,
                'name' => $name,
                'state_id' => $state,
                'municipality_id' => $municipality,
                'qr_token' => str()->random(100),
                'manager' => '',
                'phone_contact' => '',
            ]);
            $station->name = $station->name != $name ? $name : $station->name;
            $station->state_id = $station->state_id != $state ? $state : $station->state_id;
            $station->municipality_id = $station->municipality_id != $municipality ? $municipality : $station->municipality_id;
            $station->survey_id = $station->survey_id != $survey ? $survey : $station->survey_id;

            $station->save();
            return $station;
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 1);
        }
    }
}
