<?php  

namespace App\Business\UserProfile\Stations;

use App\Models\GasStation;
use Illuminate\Support\Facades\DB;

class StationsGetter 
{
    public static function getStationsByUser($user){
        $stations = DB::table('satis_gas_stations as sgs')
            ->join('satis_stations_users as ssu', 'ssu.user_id', '=', 'sgs.id')
            ->where('ssu.user_id', '=', $user)
            ->select('sgs.id', 'sgs.name', 'sgs.survey_id as survey', 'sgs.pl', 'sgs.qr_token', 'sgs.state_id as state', 'sgs.municipality_id as municipality', 'sgs.cre_id')
            ->get();

        return $stations;
    }

    public static function getStationsByAccount($account)
    {
        $stations = DB::table('satis_gas_stations as sgs')
        ->where('account_id', '=', $account)
        ->select('sgs.id', 'sgs.name', 'sgs.survey_id as survey', 'sgs.pl', 'sgs.qr_token', 'sgs.state_id as state', 'sgs.municipality_id as municipality', 'sgs.cre_id')
        ->get();

        return $stations;
    }

    public static function findSatation($station){
        $station =  GasStation::find($station);

        return $station;
    }
}