<?php  

namespace App\Business\UserProfile\Questions;

use App\Models\Question;
use App\Models\QuestionOption;
use Illuminate\Support\Facades\DB;

class QuestionsGetter
{
    public static function getQuestionsBySurvey($survey){
        $questions = DB::table('satis_questions as sq')
        ->join('satis_survies_questions as ssq', 'sq.id', '=', 'ssq.question_id')
        ->where('ssq.survey_id', $survey)
        ->where('sq.is_active', true)
        ->select('sq.*')
        ->get();

        return $questions;
    }

    public static function getQuestionById($question){
        $question = Question::where('id', $question)->select('id as question', 'question as name', 'question_type as type', 'answer_type as option_type')->first();
        return $question;
    }

    public static function getAnwesOptionsByQuestion($question){
        $options = QuestionOption::where('question_id', $question)->get();

        return $options;
    }
}