<?php  

namespace App\Admin\Users;

use App\Models\User;
use Exception;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Str;

class UsersServices
{
    public static function createUser(
        $name, 
        $email, 
        $account
    ){
        $password = Str::password(12, true, true, true);
        $user = auth('admin')->user();
        $hasUser = UsersGetter::getUserByEmail($email);
        if ($hasUser) throw new Exception("El usuario con correo {$email} ya existe", 1);

        $user = User::create([
            'user' => $name,
            'email' => $email,
            'password' => $password,
            'account_id' => $account != 0 ? $account : 0,
            'is_active' => 1,
            'created_by' => $user->id
        ]);
        $user->key = $password;
        return $user;
    }

    public static function addAccountToUser($user, $account){
        $user = User::find($user);
        $user->account_id = $account;
        $user->save();
    }
}
