<?php  

namespace App\Admin\Users;

use App\Models\User;
use Illuminate\Support\Facades\DB;

class UsersGetter
{
    public static function getUserByEmail($email){
        $user = User::where('email',$email)->first();
        return $user;
    }

    public static function getUsersByAccount($account){
        $users = DB::table('satis_users as su')
            ->join('satis_accounts as sa', 'su.account_id', '=', 'sa.id')
            ->join('satis_admin_users sau', 'sau.id', '=', 'su.created_by')
            ->where('su.account_id', '=', $account)
            ->select('a.name', 'a.email', 'sau.user as created_by', 'su.created_at')
            ->get();
        
        return $users; 
    }

    public static function getActiveUsers(){
        $users = DB::table('satis_users as su')
            ->leftJoin('satis_accounts as sa', 'su.account_id', '=', 'sa.id')
            ->select('su.id', 'su.user', 'su.email', 'sa.name as account_name', 'sa.id as account_id')
            ->get();
        return $users;
    }

    public static function hasUserAccount($user){
        $user = User::where('id', $user)->first();
        return $user->account_id != 0;
    }
}
