<?php

namespace App\Admin\Survey;

use App\Admin\Question\QuestionGetter;
use App\Models\Entities\ActiveStatus;
use App\Models\Survey;
use App\Models\SurviesQuestions;
use Exception;

class SurveyService
{
    public static function createDefualtSurvey($user, $account, $name = 'CUESTIONARIO_DEFAULT')
    {
        $survey = Survey::create([
            'name' => $name,
            'created_by_user' => $user,
            'account_id' => $account
        ]);

        self::AddQuestionsToSurvey($survey->id);

        return $survey->id;
    }

    public static function AddQuestionsToSurvey($survey)
    {
        try {
            $questions = QuestionGetter::getDefaultQuestionsId();
            $questionModel = [];

            foreach ($questions as $question) {
                $questionModel[] = [
                    'question_id' => $question->id,
                    'survey_id' =>  $survey,
                    'is_active' => ActiveStatus::Active->value
                ];
            }
            SurviesQuestions::insert($questionModel);
            return $questionModel;
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }
}
