<?php  

namespace App\Admin\Question;

use App\Models\Question;
use App\Models\QuestionOption;
use App\Models\Entities\QuestionOptionType;
use App\Models\Entities\QuestionType;
use App\Models\Entities\ActiveStatus;
use Illuminate\Support\Facades\DB;

class QuestionGetter
{
    public static function getDefaultQuestions(){
        $questions = DB::table('satis_questions as q')
            ->join('satis_answers_options as o', 'o.question_id', '=', 'q.id')
            ->join('satis_categories as c', 'q.category_id', '=', 'c.id' )
            ->select('q.*', 'o.id as answers_id','o.answers', 'c.category')->get();
        $groupedQuestions = $questions->groupBy('id')->map(function ($group) {
            $question = $group->first();
            return [
                'id' => $question->id,
                'question' => $question->question,
                'question_type' => $question->question_type,
                'answer_type' => $question->answer_type,
                'category_id' => $question->category_id,
                'can_edit' => $question->can_edit,
                'is_active' => $question->is_active,
                'created_at' => $question->created_at,
                'updated_at' => $question->updated_at,
                'category' => $question->category,
                'answers' => $group->pluck('answers', 'answers_id')->all()
            ];
        })->values();

        return $groupedQuestions;
    }

    public static function getDefaultQuestionsId(){
        $questions = Question::where('is_active',ActiveStatus::Active->value)
            ->where('question_type', QuestionType::Required->value)
            ->select('id')->get();
        return $questions;
    }
}